#region References

using System;
using System.Data;
using gov.va.med.vbecs.Common;
using TRANSFUSIONREACTION = gov.va.med.vbecs.Common.VbecsTables.TransfusionReaction;

#endregion

namespace gov.va.med.vbecs.BOL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>David Askew</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>7/20/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// Transfusion reaction business object layer class.
	///</summary>

	#endregion

	public class TransfusionReaction : BaseBusinessObject 
	{
		#region Variables

		private DataRow _drCurrent;

		#endregion

		#region Constructors

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4033"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>TransfusionReaction object</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="4034"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Default constructor
		/// </summary>
		public TransfusionReaction()
		{
			DataTable transfusionReactionTable = GetEmptyTransfusionReactionTable();

			this._drCurrent = transfusionReactionTable.NewRow();
		}


		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4035"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>TransfusionReaction object</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="4036"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Constructor : DataRow parameter
		/// </summary>
		public TransfusionReaction(DataRow tranfusionReactionRow)
		{
			DataTable transfusionReactionTable = GetEmptyTransfusionReactionTable();

			this._drCurrent = transfusionReactionTable.NewRow();
			
			this.LoadFromDataRow(tranfusionReactionRow);
		}

		#endregion

		#region Properties

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4037"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="4038"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// BagReturnedIndicator
		/// </summary>
		public bool BagReturnedIndicator
		{
			get
			{
				if (_drCurrent.IsNull(TRANSFUSIONREACTION.BagReturnedIndicator))
				{
					return false;
				}
				return Convert.ToBoolean(_drCurrent[TRANSFUSIONREACTION.BagReturnedIndicator]);
			}
			set
			{
				_drCurrent[TRANSFUSIONREACTION.BagReturnedIndicator] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4039"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="4322"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// BagHemolysisInspectionCode
		/// </summary>
		public string BagHemolysisInspectionCode
		{
			get
			{
				if (_drCurrent.IsNull(TRANSFUSIONREACTION.BagHemolysisInspectionCode))
				{
					return string.Empty;
				}
				return (string)_drCurrent[TRANSFUSIONREACTION.BagHemolysisInspectionCode];
			}
			set
			{
				_drCurrent[TRANSFUSIONREACTION.BagHemolysisInspectionCode] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4330"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="4063"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// BagClericalChecksOkIndicator
		/// </summary>
		public bool BagClericalChecksOkIndicator
		{
			get
			{
				if (_drCurrent.IsNull(TRANSFUSIONREACTION.BagClericalChecksOkIndicator))
				{
					return false;
				}
				return Convert.ToBoolean(_drCurrent[TRANSFUSIONREACTION.BagClericalChecksOkIndicator]);
			}
			set
			{
				_drCurrent[TRANSFUSIONREACTION.BagClericalChecksOkIndicator] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4064"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="4071"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// PatientTransfusionGuid
		/// </summary>
		public Guid PatientTransfusionGuid
		{
			get
			{
				if (this._drCurrent.IsNull(TRANSFUSIONREACTION.PatientTransfusionGuid))
					return Guid.Empty;

				return (Guid) this._drCurrent[TRANSFUSIONREACTION.PatientTransfusionGuid];
			}
			set
			{
				this._drCurrent[TRANSFUSIONREACTION.PatientTransfusionGuid] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4075"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="4076"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// PatientTransfusionReactionGuid
		/// </summary>
		public Guid PatientTransfusionReactionGuid
		{
			get
			{
				if (this._drCurrent.IsNull(TRANSFUSIONREACTION.PatientTransfusionReactionGuid))
					return Guid.Empty;

				return (Guid) this._drCurrent[TRANSFUSIONREACTION.PatientTransfusionReactionGuid];
			}
			set
			{
				this._drCurrent[TRANSFUSIONREACTION.PatientTransfusionReactionGuid] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4079"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="4080"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// TransfusionReactionGuid
		/// </summary>
		public Guid TransfusionReactionGuid
		{
			get
			{
				if (this._drCurrent.IsNull(TRANSFUSIONREACTION.TransfusionReactionGuid))
					return Guid.Empty;

				return (Guid) this._drCurrent[TRANSFUSIONREACTION.TransfusionReactionGuid];
			}
			set
			{
				this._drCurrent[TRANSFUSIONREACTION.TransfusionReactionGuid] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/29/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="6542"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6543"> 
		///		<ExpectedInput>InValid</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// TagNotScannedIndicator
		/// </summary>
		public bool TagNotScannedIndicator
		{
			get
			{
				if (_drCurrent.IsNull(TRANSFUSIONREACTION.TagNotScannedIndicator))
				{
					return false;
				}
				return Convert.ToBoolean(_drCurrent[TRANSFUSIONREACTION.TagNotScannedIndicator]);
			}
			set
			{
				_drCurrent[TRANSFUSIONREACTION.TagNotScannedIndicator] = value;
				this.IsDirty = true;
			}
		}

		#endregion

		#region Methods

		#region Load Methods

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		/// <summary>
		/// Creates a DataTable of the TransfusionReaction table
		/// </summary>
		/// <returns>Empty DataTable</returns>
		private DataTable GetEmptyTransfusionReactionTable()
		{
			System.Data.DataTable dt = new System.Data.DataTable(TRANSFUSIONREACTION.TableName);
			dt.Columns.Add(TRANSFUSIONREACTION.BagClericalChecksOkIndicator, typeof(byte));
			dt.Columns.Add(TRANSFUSIONREACTION.BagHemolysisInspectionCode, typeof(string));
			dt.Columns.Add(TRANSFUSIONREACTION.BagReturnedIndicator, typeof(byte));
			dt.Columns.Add(TRANSFUSIONREACTION.PatientTransfusionGuid, typeof(Guid));
			dt.Columns.Add(TRANSFUSIONREACTION.PatientTransfusionReactionGuid, typeof(Guid));
			dt.Columns.Add(TRANSFUSIONREACTION.TransfusionReactionGuid, typeof(Guid));
			dt.Columns.Add(TRANSFUSIONREACTION.LastUpdateDate, typeof(DateTime));
			dt.Columns.Add(TRANSFUSIONREACTION.RowVersion, typeof(byte []));
			dt.Columns.Add(TRANSFUSIONREACTION.TagNotScannedIndicator, typeof(byte));
			return(dt);
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		/// <summary>
		/// Load the object from the datarow parameter
		/// </summary>
		/// <param name="dtRow"></param>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
			if (dtRow.Table.Columns.Contains(TRANSFUSIONREACTION.BagClericalChecksOkIndicator))
			{
				if (!dtRow.IsNull(TRANSFUSIONREACTION.BagClericalChecksOkIndicator))
				{
					this._drCurrent[TRANSFUSIONREACTION.BagClericalChecksOkIndicator] = dtRow[TRANSFUSIONREACTION.BagClericalChecksOkIndicator];
				}
			}		
		
			if (dtRow.Table.Columns.Contains(TRANSFUSIONREACTION.BagHemolysisInspectionCode))
			{
				if (!dtRow.IsNull(TRANSFUSIONREACTION.BagHemolysisInspectionCode))
				{
					this._drCurrent[TRANSFUSIONREACTION.BagHemolysisInspectionCode] = dtRow[TRANSFUSIONREACTION.BagHemolysisInspectionCode];
				}
			}		

			if (dtRow.Table.Columns.Contains(TRANSFUSIONREACTION.BagReturnedIndicator))
			{
				if (!dtRow.IsNull(TRANSFUSIONREACTION.BagReturnedIndicator))
				{
					this._drCurrent[TRANSFUSIONREACTION.BagReturnedIndicator] = dtRow[TRANSFUSIONREACTION.BagReturnedIndicator];
				}
			}		

			if (dtRow.Table.Columns.Contains(TRANSFUSIONREACTION.PatientTransfusionGuid))
			{
				if (!dtRow.IsNull(TRANSFUSIONREACTION.PatientTransfusionGuid))
				{
					this._drCurrent[TRANSFUSIONREACTION.PatientTransfusionGuid] = dtRow[TRANSFUSIONREACTION.PatientTransfusionGuid];
				}
			}		

			if (dtRow.Table.Columns.Contains(TRANSFUSIONREACTION.PatientTransfusionReactionGuid))
			{
				if (!dtRow.IsNull(TRANSFUSIONREACTION.PatientTransfusionReactionGuid))
				{
					this._drCurrent[TRANSFUSIONREACTION.PatientTransfusionReactionGuid] = dtRow[TRANSFUSIONREACTION.PatientTransfusionReactionGuid];
				}
			}		

			if (dtRow.Table.Columns.Contains(TRANSFUSIONREACTION.TransfusionReactionGuid))
			{
				if (!dtRow.IsNull(TRANSFUSIONREACTION.TransfusionReactionGuid))
				{
					this._drCurrent[TRANSFUSIONREACTION.TransfusionReactionGuid] = dtRow[TRANSFUSIONREACTION.TransfusionReactionGuid];
				}
			}		

			if (dtRow.Table.Columns.Contains(TRANSFUSIONREACTION.LastUpdateDate))
			{
				if (!dtRow.IsNull(TRANSFUSIONREACTION.LastUpdateDate))
				{
					this.LastUpdateDate = (DateTime)dtRow[TRANSFUSIONREACTION.LastUpdateDate];
				}
			}			

			if (dtRow.Table.Columns.Contains(TRANSFUSIONREACTION.RowVersion))
			{
				if (!dtRow.IsNull(TRANSFUSIONREACTION.RowVersion))
				{
					this.RowVersion = (byte [])dtRow[TRANSFUSIONREACTION.RowVersion];
				}
			}

			if (dtRow.Table.Columns.Contains(TRANSFUSIONREACTION.TagNotScannedIndicator))
			{
				if (!dtRow.IsNull(TRANSFUSIONREACTION.TagNotScannedIndicator))
				{
					this._drCurrent[TRANSFUSIONREACTION.TagNotScannedIndicator] = dtRow[TRANSFUSIONREACTION.TagNotScannedIndicator];
				}
			}
			this.IsNew = false;
			this.IsDirty = true;
		}


		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4094"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>DataRow</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="4095"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Loads and returns a datarow with the object data
		/// </summary>
		/// <param name="dtRow"></param>
		/// <returns></returns>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			if (dtRow.Table.Columns.Contains(TRANSFUSIONREACTION.BagClericalChecksOkIndicator))
			{
				dtRow[TRANSFUSIONREACTION.BagClericalChecksOkIndicator] = this.BagClericalChecksOkIndicator;
			}
	
			if (dtRow.Table.Columns.Contains(TRANSFUSIONREACTION.BagHemolysisInspectionCode))
			{
				dtRow[TRANSFUSIONREACTION.BagHemolysisInspectionCode] = this.BagHemolysisInspectionCode;
			}

			if (dtRow.Table.Columns.Contains(TRANSFUSIONREACTION.BagReturnedIndicator))
			{
				dtRow[TRANSFUSIONREACTION.BagReturnedIndicator] = this.BagReturnedIndicator;
			}

			if (dtRow.Table.Columns.Contains(TRANSFUSIONREACTION.PatientTransfusionGuid))
			{
				dtRow[TRANSFUSIONREACTION.PatientTransfusionGuid] = this.PatientTransfusionGuid;
			}
			
			if (dtRow.Table.Columns.Contains(TRANSFUSIONREACTION.PatientTransfusionReactionGuid))
			{
				dtRow[TRANSFUSIONREACTION.PatientTransfusionReactionGuid] = this.PatientTransfusionReactionGuid;
			}

			if (dtRow.Table.Columns.Contains(TRANSFUSIONREACTION.TransfusionReactionGuid))
			{
				dtRow[TRANSFUSIONREACTION.TransfusionReactionGuid] = this.TransfusionReactionGuid;
			}

			if (dtRow.Table.Columns.Contains(TRANSFUSIONREACTION.RowVersion))
			{
				if (!dtRow.IsNull(TRANSFUSIONREACTION.RowVersion))
				{
					dtRow[TRANSFUSIONREACTION.RowVersion] = this.RowVersion;
				}
				else
				{
					dtRow[TRANSFUSIONREACTION.RowVersion] = DBNull.Value;
				}
			}

			if (dtRow.Table.Columns.Contains(TRANSFUSIONREACTION.TagNotScannedIndicator))
			{
				dtRow[TRANSFUSIONREACTION.TagNotScannedIndicator] = this.TagNotScannedIndicator;
			}

			return(dtRow);
		}




		#endregion

		#endregion
	}
}
